﻿<%@ Page Title="Referrals" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="Referrals.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.Referrals" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID = "MainContent" Runat="Server" >

    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxPatientLastNameSearch.ClientID%>').focus();

        });
    </script>     

   <div class = "excludeSaveWarnings">
   <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxPatientLastNameSearch">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxPatientLastNameSearch" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <br />
    </div>
    <br />
    <!--   -->
    <asp:GridView ID = "GridViewEFRReferrals" runat="server" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceReferralsSearch"        
        OnRowCommand = "ReferralView_RowCommand" AllowPaging="True" PageSize="20" DataKeyNames = "ReferralId" AllowSorting="true"
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
       <EmptyDataTemplate>
            No referrals exist in this status
       </EmptyDataTemplate>         
        <Columns>        
            <asp:TemplateField HeaderText = "Referral Number" SortExpression = "REFERRAL_ID">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelReferralID" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReferralId"))) %>'></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Patient Name" SortExpression="LASTNAME">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientName"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Site Number" SortExpression="STATIONNUMBER">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("StationNumber"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
           
            <asp:TemplateField HeaderText="Facility" SortExpression="FACILITY">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("InstitutionName"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Referral Date" SortExpression="REFERRAL_DATE">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientReferralDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReferralDate", "{0:d}"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                             
            <asp:TemplateField HeaderText="Status" SortExpression="STATUS">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientReferralDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReferralStatus"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
        </Columns>
    </asp:GridView>            
    <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
       
    <asp:ObjectDataSource ID="ObjectDataSourceReferralsSearch" runat="server" 
        SelectMethod="SearchReferrals" 
        SelectCountMethod="SearchReferralsCount" 
        StartRowIndexParameterName="START_ROW" 
        MaximumRowsParameterName="MAX_ROWS" 
        SortParameterName="SORT_COLUMN"
        EnablePaging="True"   
        TypeName="VIRP.EFR.BLL.ReferralManager">               
        <SelectParameters>
            <asp:Parameter Name="CURRENT_USER" Type="String" />
            <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
            <asp:Parameter Name="REFERRAL_STATUS_CODE" Type="String" />
            <asp:ControlParameter ControlID="TextBoxPatientLastNameSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_LAST_NAME" Type="String"/>  
            <asp:Parameter Name="SORT_COLUMN" Type="String" />
            <asp:Parameter Name="START_ROW" Type="Int32" />
            <asp:Parameter Name="MAX_ROWS" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>

    <asp:Panel ID="pnlModalPanel" runat="server" >    
    <table border="1"> 
        <tr>        
            <td align="left">                 
                <asp:Label SkinID="DataLabel" ID = "LabelReport" runat = "server"></asp:Label>      
            </td>   
        </tr>
        <tr>
            <td align = "center"> 
                <br />
                <br />     
            </td>        
        </tr> 
    
    </table> 
    </asp:Panel>               
</asp:Content> 